import java.util.Arrays;


public class GameStats {

	private int[] scores ;
	private int[] zap;

	public GameStats(Player[] p, int[] zap) {
		scores=new int[p.length];
		for(int i=0; i<p.length;i++)
			scores[i]=p[i].getScore();
		this.zap=zap;
	}
	public double mean(int[] a){
		double sum=0;
		for (int i=0;i<a.length;i++){
			sum+=a[i];
		}
		return sum/a.length;
	}
	public double sd(int[] a){
		double mean=mean(a);
		double sum=0;
		int n=a.length;
		for(int i=0;i<n;i++){
			sum+=Math.pow(a[i]-mean, 2);
		}
		return Math.sqrt(sum/(n-1.0));
	}
	public double median(int [] a){
		Arrays.sort(a);
		int n=a.length;
		if (n%2==0){//even
			return (a[n/2]+a[1+n/2])/2.0;
		}
		return (double)a[n/2];
	}
	public int max(int[] a){
		Arrays.sort(a);
		return a[a.length-1];
	}
	public double meanScore(){
		return mean(scores);
	}
	public double meanZapped(){
		return mean(zap);
	}
	public double sdScore(){
		return sd(scores);
	}
	public double sdZapped(){
		return sd(zap);
	}
	public double medianScore(){
		return median(scores);
	}
	public double medianZapped(){
		return median(zap);
	}
	public String toString(){
		return "Winners score:"+max(scores)+" scores mean:"+mean(scores)+" med:"+median(scores)+" sd:"+sd(scores)+
				"\nMax zapped:"+max(zap)+" zapped mean:"+mean(zap)+" med:"+median(zap)+" sd:"+sd(zap)+"\n";
	}
}
